/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.mainmenu;

import java.awt.Color;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiNpcMovement;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAI;

public class GuiNpcAI
extends GuiNPCInterface2
implements ITextfieldListener,
IGuiData {
    private final DataAI ai;
    private final String[] tactics = new String[]{"aitactics.rush", "aitactics.stagger", "aitactics.orbit", "aitactics.hitandrun", "aitactics.commander", "aitactics.stalk", "gui.none"};

    public GuiNpcAI(EntityNPCInterface npc) {
        super(npc, 6);
        this.ai = npc.ais;
        Client.sendData(EnumPacketServer.MainmenuAIGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.ai.onAttack = button.getValue();
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.ai.doorInteract = button.getValue();
                break;
            }
            case 2: {
                this.setSubGui(new SubGuiNpcMovement(this.ai));
                break;
            }
            case 5: {
                this.npc.ais.setAvoidsWater(button.getValue() == 1);
                break;
            }
            case 6: {
                this.ai.returnToStart = button.getValue() == 1;
                break;
            }
            case 7: {
                this.ai.canSwim = button.getValue() == 1;
                break;
            }
            case 9: {
                this.ai.findShelter = button.getValue();
                break;
            }
            case 10: {
                this.ai.directLOS = button.getValue() == 1;
                break;
            }
            case 15: {
                this.ai.canLeap = button.getValue() == 1;
                break;
            }
            case 16: {
                this.ai.canSprint = button.getValue() == 1;
                break;
            }
            case 17: {
                this.ai.tacticalVariant = button.getValue();
                this.ai.directLOS = button.getValue() != 5 && this.ai.directLOS;
                this.func_73866_w_();
                break;
            }
            case 18: {
                this.ai.canBeCollide = button.getValue() == 1;
                break;
            }
            case 23: {
                this.ai.attackInvisible = ((GuiNpcButtonYesNo)button).getBoolean();
                break;
            }
            case 25: {
                this.ai.aiDisabled = button.getValue() == 1;
                button.setLayerColor(this.ai.aiDisabled ? new Color(-1040352).getRGB() : new Color(-14618592).getRGB());
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int lId = 0;
        int x = this.guiLeft + 7;
        int y = this.guiTop + 10;
        this.addLabel(new GuiNpcLabel(lId++, "ai.enemyresponse", x, y + 7));
        GuiNpcButton button = new GuiNpcButton(0, x + 111, y, 60, 20, new String[]{"gui.retaliate", "gui.panic", "gui.retreat", "gui.nothing"}, this.npc.ais.onAttack);
        button.setEnabled(!this.ai.aiDisabled);
        ITextComponent mess = new TextComponentTranslation("ai.hover.if.see", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("ai.hover.if.see." + this.npc.ais.onAttack, new Object[0]));
        if (this.ai.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.door", x, (y += 25) + 7));
        button = new GuiNpcButton(1, x + 111, y, 60, 20, new String[]{"gui.break", "gui.open", "gui.disabled"}, this.npc.ais.doorInteract);
        button.setHoverText("ai.hover.door", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.swim", x, (y += 25) + 7));
        button = new GuiNpcButton(7, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.npc.ais.canSwim ? 1 : 0);
        button.setHoverText("ai.hover.water", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.shelter", x, (y += 25) + 7));
        button = new GuiNpcButton(9, x + 111, y, 60, 20, new String[]{"gui.darkness", "gui.sunlight", "gui.disabled"}, this.npc.ais.findShelter);
        button.setHoverText("ai.hover.found.refuge", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.clearlos", x, (y += 25) + 7));
        button = new GuiNpcButton(10, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.npc.ais.directLOS ? 1 : 0);
        button.setHoverText("ai.hover.found.target", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "stats.attackInvisible", x, (y += 25) + 7));
        button = new GuiNpcButtonYesNo(23, x + 111, y, 60, 20, this.ai.attackInvisible);
        button.setEnabled(!this.ai.aiDisabled);
        mess = new TextComponentTranslation("ai.hover.stealth", new Object[0]);
        if (this.ai.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.movement", x, (y += 25) + 7));
        button = new GuiNpcButton(2, x + 111, y, 60, 20, "selectServer.edit");
        button.setHoverText("ai.hover.set.walking", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.disabled", x, (y += 25) + 7));
        button = new GuiNpcButton(25, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.aiDisabled ? 1 : 0);
        button.layerColor = this.ai.aiDisabled ? new Color(-1040352).getRGB() : new Color(-14618592).getRGB();
        button.setHoverText("ai.hover.disabled", new Object[0]);
        this.addButton(button);
        x = this.guiLeft + 190;
        y = this.guiTop + 10;
        this.addLabel(new GuiNpcLabel(lId++, "ai.avoidwater", x, y + 7));
        button = new GuiNpcButton(5, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.avoidsWater ? 1 : 0);
        button.setHoverText("ai.hover.non.water", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.return", x, (y += 25) + 7));
        button = new GuiNpcButton(6, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.returnToStart ? 1 : 0);
        button.setHoverText("ai.hover.back.home", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.leapattarget", x, (y += 25) + 7));
        button = new GuiNpcButton(15, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.canLeap ? 1 : 0);
        button.setEnabled(!this.ai.aiDisabled && this.ai.onAttack == 0);
        mess = new TextComponentTranslation("ai.hover.jump", new Object[0]);
        if (this.ai.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.cansprint", x, (y += 25) + 7));
        button = new GuiNpcButton(16, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.canSprint ? 1 : 0);
        button.setHoverText("ai.hover.run", "" + (int)((double)this.npc.stats.aggroRange / 3.0));
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.hurt.resistant.time", x, (y += 25) + 7));
        GuiNpcTextField textField = new GuiNpcTextField(4, this, this.field_146289_q, x + 112, y + 1, 58, 18, this.ai.getMaxHurtResistantTime() / 2 + "");
        textField.setMinMaxDefault(0L, 100L, this.ai.getMaxHurtResistantTime() / 2);
        textField.setHoverText("ai.hover.hurt.resistant.time", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "ai.can.be.collide", x, (y += 25) + 7));
        button = new GuiNpcButton(18, x + 111, y, 60, 20, new String[]{"gui.no", "gui.yes"}, this.ai.canBeCollide ? 1 : 0);
        button.setHoverText("ai.hover.can.be.collide", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "ai.tacticalvariant", x, (y += 25) + 7));
        button = new GuiNpcButton(17, x + 111, y, 60, 20, this.tactics, this.ai.tacticalVariant);
        button.setEnabled(!this.ai.aiDisabled && this.ai.onAttack == 0);
        mess = new TextComponentTranslation("ai.hover.attack.type", new Object[]{button.field_146126_j}).func_150257_a((ITextComponent)new TextComponentTranslation("ai.hover.attack.type." + this.ai.tacticalVariant, new Object[0]));
        if (this.ai.aiDisabled) {
            mess.func_150257_a((ITextComponent)new TextComponentTranslation("hover.ai.disabled", new Object[0]));
        }
        button.setHoverText(mess.func_150254_d(), new Object[0]);
        this.addButton(button);
        if (this.ai.tacticalVariant != 0 && this.ai.tacticalVariant != 6) {
            String label;
            switch (this.ai.tacticalVariant) {
                case 1: {
                    label = "gui.dodgedistance";
                    break;
                }
                case 2: {
                    label = "gui.orbitdistance";
                    break;
                }
                case 3: {
                    label = "gui.fightifthisclose";
                    break;
                }
                case 4: {
                    label = "gui.searchdistance";
                    break;
                }
                case 5: {
                    label = "gui.proximity";
                    break;
                }
                default: {
                    label = "gui.engagedistance";
                }
            }
            this.addLabel(new GuiNpcLabel(lId, label, x, (y += 25) + 7));
            textField = new GuiNpcTextField(3, this, this.field_146289_q, x + 112, y + 1, 58, 18, this.ai.getTacticalRange() + "");
            textField.setMinMaxDefault(1L, this.npc.stats.aggroRange, 5L);
            textField.setHoverText("ai.hover.attack.range", new Object[0]);
            this.addTextField(textField);
        }
    }

    @Override
    public void save() {
        Client.sendData(EnumPacketServer.MainmenuAISave, this.ai.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.ai.readToNBT(compound);
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        if (textfield.getID() == 3) {
            this.ai.setTacticalRange(textfield.getInteger());
        } else if (textfield.getID() == 4) {
            this.ai.setMaxHurtResistantTime(textfield.getInteger() * 2);
            if (textfield.getInteger() * 2 != this.ai.getMaxHurtResistantTime()) {
                textfield.setFullText("" + this.ai.getMaxHurtResistantTime());
            }
        }
    }
}

